import React, { useEffect, useState } from 'react';
import api from './api_client';

function Dashboard({ onLogout }) {
  const [summary, setSummary] = useState(null);
  const [error, setError] = useState('');

  useEffect(() => {
    const load = async () => {
      try {
        const res = await api.get('/api/agent/summary');
        setSummary(res.data);
      } catch (err) {
        setError(err.response?.data?.message || 'Failed to load summary');
      }
    };
    load();
  }, []);

  return (
    <div className="layout-main">
      <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
        <div>
          <h1 className="page-title">Agent Dashboard</h1>
          <p className="page-sub">Users under you • Their coins • Pending withdraws</p>
        </div>
        <button
          onClick={onLogout}
          style={{
            padding: '8px 14px',
            borderRadius: 999,
            border: '1px solid rgba(255,255,255,0.4)',
            background: 'transparent',
            color: '#f8f5ff',
            cursor: 'pointer',
            fontSize: 12,
          }}
        >
          🚪 Logout
        </button>
      </div>
      {error && <p style={{ marginTop: 16, color: '#ff4b6e', fontSize: 12 }}>{error}</p>}
      {summary && (
        <div className="stats-grid">
          <div className="stat-card">
            <div className="stat-label">Users Under Me</div>
            <div className="stat-value">{summary.usersUnderMe}</div>
          </div>
          <div className="stat-card">
            <div className="stat-label">Users Total Balance</div>
            <div className="stat-value">₹ {summary.usersTotalBalance}</div>
          </div>
          <div className="stat-card">
            <div className="stat-label">Pending Withdraw Requests</div>
            <div className="stat-value">{summary.pendingWithdrawCount}</div>
          </div>
        </div>
      )}
    </div>
  );
}

export default Dashboard;
