const express = require('express');
const prisma = require('../config/db');
const { authMiddleware, requireRole } = require('../middleware/auth');

const router = express.Router();

router.get('/me', authMiddleware, requireRole('USER'), async (req, res) => {
  try {
    const user = await prisma.user.findUnique({
      where: { id: req.user.id },
      include: { role: true, wallet: true },
    });
    if (!user) return res.status(404).json({ message: 'User not found' });

    return res.json({
      id: user.id,
      uid: user.uid,
      name: user.name,
      email: user.email,
      role: user.role.name,
      wallet: user.wallet ? { balance: user.wallet.balance } : { balance: 0 },
    });
  } catch (err) {
    console.error('user me error:', err);
    return res.status(500).json({ message: 'Internal server error' });
  }
});

module.exports = router;
