const express = require('express');
const prisma = require('../config/db');
const { authMiddleware, requireRole } = require('../middleware/auth');

const router = express.Router();

router.get('/summary', authMiddleware, requireRole('SUPERADMIN'), async (req, res) => {
  try {
    const [agentCount, userCount, directUsers, viaAgents] = await Promise.all([
      prisma.user.count({ where: { role: { name: 'AGENT' } } }),
      prisma.user.count({ where: { role: { name: 'USER' } } }),
      prisma.user.count({ where: { role: { name: 'USER' }, agentId: null } }),
      prisma.user.count({ where: { role: { name: 'USER' }, agentId: { not: null } } }),
    ]);

    return res.json({
      agents: agentCount,
      users: userCount,
      usersDirect: directUsers,
      usersViaAgents: viaAgents,
      totalTurnover: 0,
      totalWithdraw: 0,
    });
  } catch (err) {
    console.error('admin summary error:', err);
    return res.status(500).json({ message: 'Internal server error' });
  }
});

module.exports = router;
