require('dotenv').config();
const express = require('express');
const cors = require('cors');
const helmet = require('helmet');
const morgan = require('morgan');

const authRoutes = require('./routes/auth');
const adminRoutes = require('./routes/admin');
const agentRoutes = require('./routes/agent');
const userRoutes = require('./routes/user');
const gameRoutes = require('./routes/game');

const app = express();

const adminOrigin = process.env.CORS_ORIGIN_ADMIN || 'http://localhost:5173';
const agentOrigin = process.env.CORS_ORIGIN_AGENT || 'http://localhost:5174';
const userOrigin = process.env.CORS_ORIGIN_USER || 'http://localhost:5175';

app.use(express.json());
app.use(
  cors({
    origin: [adminOrigin, agentOrigin, userOrigin],
  })
);
app.use(helmet());
app.use(morgan('dev'));

app.get('/', (req, res) => {
  res.json({ status: 'ok', phase: 3, app: 'Green Color App Backend Phase 3' });
});

app.use('/api/auth', authRoutes);
app.use('/api/admin', adminRoutes);
app.use('/api/agent', agentRoutes);
app.use('/api/user', userRoutes);
app.use('/api/game', gameRoutes);

const PORT = process.env.PORT || 4000;
app.listen(PORT, () => {
  console.log(`Phase 3 backend running on port ${PORT}`);
});
